<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Controller\Adminhtml\Configuration;

use Magento\Backend\App\Action;
use Magento\Framework\Exception\State\UserLockedException;
use Magento\Integration\Controller\Adminhtml\Integration\Save;

abstract class Base extends Action
{

    public function _isAllowed(): bool
    {
        return $this->_authorization->isAllowed(self::ADMIN_RESOURCE);
    }

    /**
     * @return bool
     */
    protected function isValidPostRequest()
    {
        $formKeyIsValid = $this->_formKeyValidator->validate($this->getRequest());
        $isPost = $this->getRequest()->isPost();
        return ($formKeyIsValid && $isPost);
    }

    /**
     * Validate current user password
     *
     * @return $this
     * @throws UserLockedException
     * @throws \Magento\Framework\Exception\AuthenticationException
     */
    protected function validateUser()
    {
        $password = $this->getRequest()->getParam('current_password');
        $user = $this->_auth->getUser();
        $user->performIdentityCheck($password);
        return $this;
    }

    protected function redirect()
    {
        $this->_redirect('pbf/configuration');
    }
}
