<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Controller\Adminhtml\Configuration;

use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\Exception\IntegrationException;
use Magento\Framework\Phrase;
use Magento\Framework\View\Result\PageFactory;
use Magento\Integration\Api\IntegrationServiceInterface;
use Magento\Integration\Api\OauthServiceInterface;
use Magento\Integration\Controller\Adminhtml\Integration as IntegrationController;
use Novuna\Pbf\Logger\PbfLoggerInterface;
use Novuna\Pbf\Model\StoreConfigProvider;
use Novuna\Pbf\Model\Widget\PbfWidgetConfigProvider;

class Installation extends Base
{
    const ADMIN_RESOURCE = 'Novuna_Pbf::paybyfinance';
    private StoreConfigProvider $storeConfigProvider;
    private IntegrationServiceInterface $integrationService;
    private PbfLoggerInterface $logger;
    private OauthServiceInterface $oauthService;
    private PageFactory $resultPageFactory;
    private PbfWidgetConfigProvider $pbfWidgetConfigProvider;
    private ScopeConfigInterface $scopeConfig;
    

    public function __construct(
        StoreConfigProvider $storeConfigProvider,
        IntegrationServiceInterface $integrationService,
        OauthServiceInterface $oauthService,
        PbfLoggerInterface $logger,
        PageFactory $resultPageFactory,
        Context $context,
        PbfWidgetConfigProvider $pbfWidgetConfigProvider,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->integrationService = $integrationService;
        $this->oauthService = $oauthService;
        $this->logger = $logger;
        $this->storeConfigProvider = $storeConfigProvider;
        $this->resultPageFactory = $resultPageFactory;
        $this->pbfWidgetConfigProvider = $pbfWidgetConfigProvider;
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context);
    }

    public function execute()
    {
        $integrationId = (int)$this->getRequest()->getParam(IntegrationController::PARAM_INTEGRATION_ID);
        if ($integrationId) {
            try {
                $integration = $this->integrationService->get($integrationId);
                if ($integration->getStatus()) {
                    $result = $this->resultPageFactory->create();
                    if ($result instanceof Page) {
                        $result->setActiveMenu(self::ADMIN_RESOURCE);
                        $result->getConfig()->getTitle()->prepend(new Phrase('PBF - Installation'));
                    }
                    
                    list($scope, $scopeId) = $this->pbfWidgetConfigProvider->getInstallationPoint();
                    $this->storeConfigProvider->enablePayByFinance(1, $scope, $scopeId);
                    
                    return $result;
                } else {
                    $this->messageManager->addErrorMessage(__('Unable to Install PBF, please try again'));
                }
            } catch (\Exception $e) {
                $this->logger->critical($e);
                $this->messageManager->addErrorMessage(__('Error: "%1"', $e->getMessage() ));
                $this->redirect();
                return;
            }
        }
        $this->redirect();
    }
}
