<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Controller\Cart;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Serialize\Serializer\Json;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Quote\Model\Quote;
use Novuna\Pbf\Logger\PbfLoggerInterface;
use Novuna\Pbf\ViewModel\Checkout\PbfWidget;

class Index implements HttpGetActionInterface, CsrfAwareActionInterface
{
    private JsonFactory $resultJsonFactory;
    private Json $serializer;
    private CheckoutSession $checkoutSession;
    /**
     * @var \Magento\Quote\Api\Data\CartInterface|Quote
     */
    private $quote;
    private CartRepositoryInterface $quoteRepository;
    private PbfLoggerInterface $logger;
    private PbfWidget $pbfWidget;

    public function __construct(
        JsonFactory $resultJsonFactory,
        Json $serializer,
        CheckoutSession $checkoutSession,
        PbfLoggerInterface $logger,
        PbfWidget $pbfWidget
    ) {
        $this->resultJsonFactory = $resultJsonFactory;
        $this->serializer = $serializer;
        $this->checkoutSession = $checkoutSession;
        $this->logger = $logger;
        $this->pbfWidget = $pbfWidget;
    }

    /**
     * Execute view action
     *
     * @return ResultInterface
     */
    public function execute(): ResultInterface
    {
        try {
            $config = [];
            $currentQuote = $this->getQuote();
            if ($currentQuote->getId()) {
                $currentQuote->collectTotals();
                $config = $this->pbfWidget->generateCartConfig();
            }

        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
        }
        $resultJson = $this->resultJsonFactory->create();
        return $resultJson->setData($config);
    }

    public function createCsrfValidationException(RequestInterface $request): ?InvalidRequestException
    {
        return null;
    }

    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }

    protected function getQuote()
    {
        if (!$this->quote) {
            $this->quote = $this->checkoutSession->getQuote();
        }
        return $this->quote;
    }
}
