<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model;

use Magento\Framework\Exception\NotFoundException;
use Novuna\Pbf\Api\CmsPageRepositoryInterface;
use Novuna\Pbf\Api\Data\CmsPageDataInterface;
use Novuna\Pbf\Model\Data\CmsPageData;
use Novuna\Pbf\Model\ResourceModel\Webhook as ResourceCmsPage;
use Novuna\Pbf\Model\ResourceModel\Webhook\Collection;
use Novuna\Pbf\Model\ResourceModel\Webhook\CollectionFactory as WebhookCollectionFactory;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Cms\Model\Page;

class CmsPageRepository implements CmsPageRepositoryInterface
{
    private PageHelper $pageHelper;
    private Page $page;
    private \Magento\Cms\Model\ResourceModel\Page\Collection $pageCollection;
    private \Magento\Cms\Model\Template\FilterProvider $filterProvider;

    public function __construct(
        Page $page,
        \Magento\Cms\Model\ResourceModel\Page\Collection $pageCollection,
        \Magento\Cms\Model\Template\FilterProvider $filterProvider
    ) {
        $this->page = $page;
        $this->pageCollection = $pageCollection;
        $this->filterProvider = $filterProvider;
    }

    /**
     * @inheritDoc
     */
    public function getByHandle(string $handle, $storeId = null): CmsPageDataInterface{
        if ($storeId !== null) {
            $this->page->setStoreId($storeId);
        }
        if (!$this->page->load($handle, \Magento\Cms\Api\Data\PageInterface::IDENTIFIER)) {
            throw new NotFoundException('CMS Page, identifier: ' . $handle);
        }

        $page = $this->page;

        $pageData = new CmsPageData($this->page, $this->filterProvider->getPageFilter());
        return $pageData;
    }

    public function getAllPages($storeId = null): ?array{
        if ($storeId !== null) {
            $this->pageCollection->addStoreFilter($storeId, false);
        }
        $pages = [];

        $collection = $this->pageCollection->load();
        foreach ($collection as $p) {
            $pages[] =  $p;
        }
        return $pages;
    }
}

