<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Magento\Cms\Model\Page;
use Novuna\Pbf\Api\Data\CmsPageDataInterface;

/**
 * @api
 */
class CmsPageData implements CmsPageDataInterface
{

    private $id;
    private $identifier;
    private $title;
    private $content;
    private $active;

    public function __construct(
        Page $page,
        \Magento\Cms\Model\Template\Filter $filter
    ) {
        $this->id = $page->getId();
        $this->identifier = $page->getIdentifier();
        $this->content = $filter->filter($page->getContent());
        $this->active = $page->isActive();
        $this->title = $page->getTitle();
    }


    /**
     * @return mixed
     */
    public function getId()
    {
        return (int)$this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id): void
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getIdentifier(): ?string
    {
        return $this->identifier;
    }

    /**
     * @param mixed $identifier
     */
    public function setIdentifier($identifier): void
    {
        $this->identifier = $identifier;
    }

    /**
     * @return mixed
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }

    /**
     * @param mixed $title
     */
    public function setTitle($title): void
    {
        $this->title = $title;
    }

    /**
     * @return mixed
     */
    public function getContent(): ?string
    {
        return $this->content;
    }

    /**
     * @param mixed $content
     */
    public function setContent($content): void
    {
        $this->content = $content;
    }

    /**
     * @return mixed
     */
    public function isActive(): bool
    {
        return $this->active;
    }

    /**
     * @param mixed $active
     */
    public function setActive($active): void
    {
        $this->active = $active;
    }

}
