<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Plugin\UiComponent\Sales\Grid;

use Magento\Framework\View\Element\UiComponent\DataProvider\CollectionFactory;
use Magento\Sales\Model\ResourceModel\Order\Grid\Collection as SalesOrderGridCollection;
use Magento\Framework\DB\Sql\Expression;

class SalesOrderTotal
{
    private SalesOrderGridCollection $collection;

    public function __construct(
        SalesOrderGridCollection $collection
    ) {
        $this->collection = $collection;
    }

    public function afterGetReport(
        CollectionFactory $subject,
        $collection,
        $requestName
    ) {
        if ($requestName == 'sales_order_grid_data_source' && $collection instanceof $this->collection) {
            $connection = $this->collection->getConnection();
            $select = $collection->getSelect();
            $select->columns(
                [
                    'total_purchased_incl_pbf' => new Expression(
                        sprintf(
                            'SUM(%s + ABS(%s))',
                            $connection->getIfNullSql('main_table.grand_total', 0),
                            $connection->getIfNullSql('main_table.pbf_finance_amount', 0)
                        )
                    )
                ]
            );
            $select->group(['main_table.entity_id']);
        }
        return $collection;
    }
}
