<?php

namespace Novuna\Pbf\Setup\Operation;

use Magento\Catalog\Api\Data\ProductAttributeInterface;
use Magento\Catalog\Model\Product;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\DB\Sql\Expression;

class UpdateAttributeAndConfigTo201
{
    private $setup;
    private ModuleDataSetupInterface $moduleDataSetup;
    private EavSetupFactory $eavSetupFactory;

    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    public function execute(SchemaSetupInterface $setup)
    {
        $this->setup = $setup;
        try {
            $this->updateCoreConfigPaths();
            $this->updateAttributes();
        } catch (\Exception $e) {

            echo $e->getMessage();
        }
    }

    private function updateAttributes()
    {
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $oldAttributeId = $eavSetup->getAttributeId(
            Product::ENTITY,
            'paybyfinance_enable'
        );

        if ($oldAttributeId) {
            $this->setup->getConnection()->update(
                $this->setup->getTable('eav_attribute'),
                [
                    'attribute_code' => 'pbf_enable'
                ],
                ['`attribute_id` = ?' => $oldAttributeId]
            );
        }
    }

    private function updateCoreConfigPaths()
    {
        /**
         * UPDATE core_config_data
         * SET path = REPLACE(path, 'paybyfinance/', 'pbf/')
         * WHERE path LIKE 'paybyfinance/%';
         */
        $pathField = $this->setup->getConnection()->quoteIdentifier('path');
        $this->setup->getConnection()->update(
            $this->setup->getTable('core_config_data'),
            [
                'path' => new Expression(
                    'REPLACE(' .
                    $pathField . ',' .
                    $this->setup->getConnection()->quote('paybyfinance/') . ', ' .
                    $this->setup->getConnection()->quote('pbf/') .
                    ')'
                ),
            ],
            [$pathField . ' LIKE ?' => 'paybyfinance/%']
        );
    }
}
