<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api;

use Novuna\Pbf\Api\Data\OrderRiskDataInterface;
use Novuna\Pbf\Model\ResourceModel\OrderRisk\Collection;

/**
 * CRUD interface.
 * @api
 * @since 100.0.2
 */
interface OrderRiskRepositoryInterface
{

    /**
     * Save order risk.
     *
     * @param \Novuna\Pbf\Api\Data\OrderRiskDataInterface $risk
     * @return \Novuna\Pbf\Api\Data\OrderRiskDataInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(\Novuna\Pbf\Api\Data\OrderRiskDataInterface $risk);

    /**
     * Retrieve order risks.
     *
     * @param int $orderRiskId
     * @return \Novuna\Pbf\Api\Data\OrderRiskDataInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($orderRiskId);

    /**
     * Retrieve order risks.
     *
     * @param int $orderId
     * @return Collection
     */
    public function getOrderRisks(
        int $orderId
    ): Collection;

    /**
     * Gets order risk with the same paramteres on given order.
     *
     * @param int $orderId
     * @param \Novuna\Pbf\Api\Data\OrderRiskDataInterface $risk
     * @return \Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function existRisk(
        int $orderId, \Novuna\Pbf\Api\Data\OrderRiskDataInterface $risk
    ): ?OrderRiskDataInterface;

    /**
     * Delete order risk by ID.
     *
     * @param string $riskId
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function deleteById($riskId);

    /**
     * Delete all order risk by order ID.
     *
     * @param string $orderId
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function deleteAll($orderId);
}
