<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Block\Adminhtml\Order;

use Magento\Framework\Registry;
use Magento\Sales\Helper\Admin;
use Magento\Backend\Block\Template\Context;
use Magento\Sales\Model\Order\Address\Renderer;
use Magento\Customer\Api\GroupRepositoryInterface;
use Magento\Customer\Api\CustomerMetadataInterface;
use Magento\Customer\Model\Metadata\ElementFactory;
use Novuna\Pbf\Api\Data\DraftOrderDataInterface;
use Novuna\Pbf\Api\OrderRiskRepositoryInterface;
use Novuna\Pbf\Model\OrderRisk;
use Novuna\Pbf\Model\Sales\Service\FraudCheckService;
use Magento\Backend\Model\UrlInterface;

class Info extends \Magento\Sales\Block\Adminhtml\Order\View\Info
{
    private FraudCheckService $fraudCheckService;
    private UrlInterface $backendUrl;
    private OrderRiskRepositoryInterface $orderRiskRepository;

    public function __construct(
        Context $context,
        Registry $registry,
        Admin $adminHelper,
        GroupRepositoryInterface $groupRepository,
        CustomerMetadataInterface $metadata,
        ElementFactory $elementFactory,
        Renderer $addressRenderer,
        FraudCheckService $fraudCheckService,
        UrlInterface $backendUrl,
        OrderRiskRepositoryInterface $orderRiskRepository,
        array $data = []
    ) {
        $this->fraudCheckService = $fraudCheckService;
        $this->backendUrl = $backendUrl;
        $this->orderRiskRepository = $orderRiskRepository;

        parent::__construct($context, $registry, $adminHelper, $groupRepository, $metadata, $elementFactory, $addressRenderer, $data);
    }

    public function getFraudInfo(): array
    {
        $order = $this->getOrder();
        if ($order->getData(DraftOrderDataInterface::FINANCE_STATE_RO_FIELD) == FraudCheckService::PBF_DECLINED_STATE) {
            return ['Finance Declined'];
        }
        $risks = $this->orderRiskRepository->getOrderRisks((int)$order->getId());
        $pbfFraudChecked = (bool)$order->getData(OrderRisk::FRAUD_CHECKED);
        return $this->fraudCheckService->getPbfFraudStatusMessage($pbfFraudChecked, $risks);
    }

    public function getShowPostDataUrl(): string
    {
        return $this->backendUrl->getUrl('pbf/postdata', ['order_id' => $this->getOrder()->getId()]);
    }

    public function isFinancedorder(): bool {
        return (bool)$this->getOrder()->getPbfFinanceEnabled();
    }
}
