<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\ProductMetaDataInterface;

/**
 * @api
 */
class ProductMetaData implements ProductMetaDataInterface
{
    /** @var int|null */
    private $productId;

    /** @var string[] */
    private $tags;

    public function __construct(
        ?int $productId = null,
        array $tags = []
    ) {

        $this->productId = $productId;
        $this->tags = $tags;
    }

    public function getId(): ?int
    {
        return $this->productId;
    }

    /**
     * @return string[]
     */
    public function getTags(): array
    {
        return $this->tags;
    }
}
