<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\SettingsWrapperInterface;

/**
 * @api
 */
class SettingsWrapper implements SettingsWrapperInterface
{
    private string $settings;

    public function __construct(
        string $settings = null
    ) {
        $this->settings = $settings;
    }

    /**
     * @inheritDoc
     */
    public function getSettings(): string
    {
        return $this->settings;
    }

    /**
     * @inheritDoc
     */
    public function setSettings(string $settings = null)
    {
        $this->settings = $settings;
    }
}
