<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model;

use Magento\Framework\Model\AbstractModel;
use Novuna\Pbf\Model\Data\OrderMeta;
use Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface;
use Novuna\Pbf\Model\ResourceModel\SalesOrderMeta as SalesOrderMetaResource;

class SalesOrderMeta extends AbstractModel implements OrderMetaFieldDataInterface
{

    protected function _construct()
    {
        $this->_init(SalesOrderMetaResource::class);
    }

    public function getId(): ?int
    {
        $id = $this->getData(OrderMeta::META_ID);
        return $id ? (int)$id : null;
    }

    public function setId($id)
    {
        return $this->setData(OrderMeta::META_ID, $id);
    }

    public function getOrderId(): ?int
    {
        return (int)$this->getData(OrderMeta::META_DATA_ORDER_ID);
    }

    public function setOrderId($orderId)
    {
        return $this->setData(OrderMeta::META_DATA_ORDER_ID, $orderId);
    }
    public function getQuoteId(): ?int
    {
        return (int)$this->getData(OrderMeta::META_DATA_ORDER_ID);
    }

    public function setQuoteId($quoteId)
    {
        return $this->setData(OrderMeta::META_DATA_QUOTE_ID, $quoteId);
    }

    public function getKey(): ?string
    {
        return $this->getData(OrderMeta::META_DATA_KEY);
    }

    public function setKey($key)
    {
        return $this->setData(OrderMeta::META_DATA_KEY, $key);
    }

    public function getValue(): ?string
    {
        return $this->getData(OrderMeta::META_DATA_VALUE);
    }

    public function setValue($value)
    {
        return $this->setData(OrderMeta::META_DATA_VALUE, $value);
    }
}
