<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Total\Creditmemo;

use Magento\Sales\Model\Order\Creditmemo;
use Magento\Sales\Model\Order\Creditmemo\Total\AbstractTotal;
use Novuna\Pbf\Model\Utils\TotalCalculateUtils;

class FinanceAmount extends AbstractTotal
{
    /**
     * Add financed amount to totals so grandTotal ( = sum that will should refunded) will reflect the total
     * - financed amount (user payed only deposit)
     *
     * @param Creditmemo $creditmemo
     * @return $this
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function collect(Creditmemo $creditmemo)
    {
        $order = $creditmemo->getOrder();
        if ($order->getPbfFinanceAmount() &&
            !TotalCalculateUtils::bcCompare(
                floatval($order->getPbfFinanceAmountRefunded()),
                floatval($order->getPbfFinanceAmount())
            )
        ) {
            $amount = abs(floatval($order->getPbfFinanceAmount()));
            $baseAmount = abs(floatval($order->getPbfBaseFinanceAmount()));
            if (TotalCalculateUtils::bcCompare($amount, 0)) {
                return $this;
            }

            $creditmemo->setPbfFinanceAmount(-$amount);
            $creditmemo->setPbfBaseFinanceAmount(-$baseAmount);

            $creditmemo->setGrandTotal($creditmemo->getGrandTotal() - $amount);
            $creditmemo->setBaseGrandTotal($creditmemo->getBaseGrandTotal() - $baseAmount);
        }

        return $this;
    }
}
