<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Plugin\Sales\Model;

use Magento\Sales\Model\Order;

class State
{
    /**
     * M2 is checking order ship status to update its state
     * Plugin added to bypass canship plugin added for fraud check
     * M2 is setting order state to compete if it's in Processing and canShip() is false ;-(
     * We need to return true to keep M2 core skipping this...
     * @param \Magento\Sales\Model\ResourceModel\Order\Handler\State $subject
     * @param Order $order
     *
     * @return Order[]
     */
    public function beforeCheck(\Magento\Sales\Model\ResourceModel\Order\Handler\State $subject, Order $order)
    {
        $order->setSkipFraudCheck(true);
        return [$order];
    }


}
