<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Setup\Patch;

use Magento\Catalog\Model\Product;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

abstract class ProductAttributes implements DataPatchInterface
{
    private EavSetupFactory $eavSetupFactory;
    private ModuleDataSetupInterface $moduleDataSetup;
    const ATTRIBUTE_GROUP = 'Novuna PaybyFinance';

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param EavSetupFactory $eavSetupFactory
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    abstract public function getAttributeData(): array;

    /**
     * @return ProductAttributes|void
     */
    public function apply()
    {
        $attributeData = $this->getAttributeData();

        if (!empty($attributeData)) {
            $this->createAttributes($attributeData);
        }
    }

    /**
     * Apply patch changes
     *
     * @return void
     */
    public function createAttributes($attributes)
    {
        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);

        foreach ($attributes as $code => $attributeData) {
            try {
                $eavSetup->addAttribute(
                    Product::ENTITY,
                    $code,
                    $attributeData
                );
            } catch (\Exception $e) {
                continue;
            }
        }
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }
}
