<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Ui\Component\Sales\Grid\Column\PbfFraud;

use Magento\Framework\Data\OptionSourceInterface;
use Novuna\Pbf\Model\Sales\Service\FraudCheckService;
use Novuna\Pbf\Model\StoreConfigProvider;

class Options implements OptionSourceInterface
{
    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            [
                'value' => 0,
                'label' => __(FraudCheckService::NOT_VERIFIED),
            ],
            [
                'value' => 1,
                'label' => __(FraudCheckService::GOOD_TO_SHIP),
            ],
            [
                'value' => 2,
                'label' => __(FraudCheckService::POSSIBLE_RISK),
            ]
        ];
    }
}
