<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\DataObject;

abstract class AbstractPbfWidgetProvider extends DataObject implements ArgumentInterface
{
    abstract public function getScriptSrc(): ?string;

    abstract public function getJsonConfig(): string;

    abstract public function getJsonDataType(): string;

    abstract public function canShowWidget(): bool;
}
