<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Label;

class LabelsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Label::updateOrCreate([
            'name' => 'Just Arrived',
            'type' => null,
        ], [
            'data' => [
                'auto_assign' => true,
                'assign_when' => 'just_arrived',
                'auto_revoke' => true,
                'revoke_when' => 'not_just_arrived',
                'display_type_options' => [
                    [
                        'id' => 'all',
                        'name' => 'All'
                    ],
                    [
                        'id' => 'srp',
                        'name' => 'Search Page Only'
                    ],
                    [
                        'id' => 'fpa',
                        'name' => 'Full Page Advert Only'
                    ],
                ],
                'advanced_rules' => false
            ]
        ]);
    }
}
