<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class SiteAccessPasswordSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Restricted access',
                'name' => 'Enabled',
                'config_key' => 'site-access-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Restrict access to website via password screen',
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Restricted access',
                'name' => 'Password',
                'config_key' => 'site-access-password',
                'type' => 'secret',
                'value' => Str::random(10),
                'validation_rules' => [
                    "required_if:values.site-access-enabled,true"
                ]
            ],

        ];
    }
}
