<?php

namespace App\Modules\Sales\Services;

use Mtc\MercuryDataModels\Vehicle;

class CodeWeavers
{
    /**
     * Create ecommerce data array
     *
     * @param Vehicle $vehicle
     * @return array
     */
    public function ecommerceData(Vehicle $vehicle): array
    {
        return [
            'url' => $vehicle->financeExamples()
                ->where('provider', 'codeweavers')
                ->where('monthly_price', $vehicle->monthly_price)
                ->first()
                ?->apply_url
        ];
    }
}
