<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class GoodbyeCarValuationSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'Goodbye Car',
                'name' => 'Enabled',
                'config_key' => 'valuation-goodbye-car-enabled',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'Goodbye Car',
                'name' => 'API Key',
                'config_key' => 'valuation-goodbye-car-api-key',
                'type' => 'string',
                'min_tier' => 'pro',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.valuation-goodbye-car-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'General',
                'name' => 'Require customer details before showing a valuation',
                'config_key' => 'valuation-require-customer-details',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
        ];
    }
}
