<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SendEnquiryToVehicleDealershipSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Enquiries',
                'name' => 'Send vehicle enquiries to dealership',
                'config_key' => 'form-enquiry-send-to-vehicle-dealership',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
