<?php

namespace Tests\Tenant;

use Illuminate\Support\Facades\Storage;
use Tests\TenantTestCase;

class FacebookFeedTest extends TenantTestCase
{
    public function setUp(): void
    {
        parent::setUp();
        Storage::fake('public');
    }

    public function testFacebookCsvDownload()
    {
        $response = $this->get(route('tenant.feeds.facebook', tenant('id')) . '?api_token=' . config('auth.api_auth_token') . '&download=true');

        $response->assertStatus(200);
        $response->assertHeader('Content-Type', 'text/csv; charset=UTF-8');
        $response->assertHeader('Content-Disposition', 'attachment; filename=facebook_feed.csv');
    }

    public function testFacebookCsvDisplay()
    {
        $response = $this->get(route('tenant.feeds.facebook', tenant('id')) . '?api_token=' . config('auth.api_auth_token'));

        $response->assertStatus(200);
        $response->assertSee("id", "title", "description", "availability", "condition", "price", "link", "image_link", "brand", "sale_price", "additional_image_link", "color");
    }
}
