<?php

namespace App\Crm;

use Illuminate\Support\Facades\Config;
use Mtc\Crm\Contracts\EnquiryActionModel;

trait CheckForExpiredAction
{
    protected function expired(EnquiryActionModel $action): bool
    {
        return $action->newQuery()
            ->where('id', $action->id)
            ->where(fn($query) => $query
                ->whereNotNull('processed_at')
                ->orWhere('attempts', '>=', Config::get('crm.enquiry_action_max_attempts')))
            ->exists();
    }
}
