<?php

namespace App\Http\Requests;

use App\Facades\Settings;
use App\Rules\VehicleExistsByIdentifier;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Country;
use Mtc\MercuryDataModels\Vehicle;

class AutoImagingStoreRequest extends AutoImagingRequest
{
    protected ?Model $vehicle;

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'vehicleId' => [
                'required',
            ],
            'images' => [
                'sometimes',
                'array'
            ],
            'vimeoUrl' => [
                'sometimes',
            ],
        ];
    }

    /**
     * Get the vehicle record
     *
     * @return Vehicle|Model|null
     */
    public function vehicle(): ?Vehicle
    {
        if (!isset($this->vehicle)) {
            $country = Settings::get('app-details-country') ?? config('app.default_country');
            $this->vehicle = Vehicle::query()
                ->where('registration_number', Country::normalizeNumberPlate($country, $this->input('vehicleId')))
                ->orWhere('vin', $this->input('vehicleId'))
                ->first();
        }

        return $this->vehicle;
    }
}
