<?php

namespace App\Reporting\StatsModels;

use App\Contracts\StatsModel;
use Carbon\Carbon;
use Mtc\MercuryDataModels\Vehicle;

class VehicleCount implements StatsModel
{
    /**
     * @return string
     */
    public function getKey(): string
    {
        return 'vehicle-count';
    }

    /**
     * @param Carbon $date
     * @return int
     */
    public function getValue(Carbon $date): mixed
    {
        return Vehicle::query()
            ->active()
            ->count();
    }
}
