<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PriceChangeUpdateOriginalPriceSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Price change will update original price value',
                'config_key' => 'vehicles-price-change-updates-original-price',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
                'order' => 20,
                'description' => 'When stock sync changes price to a lower one, it will update original price.'
                    . ' If price increases it will be set to empty value',
            ],
        ];
    }
}
