<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\ContentManager\Models\Template;
use Mtc\MercuryDataModels\OfferType;

class OfferTypeView extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'type' => $this->resource->toArray(),
            'templates' => Template::query()->active()->select(['name', 'id'])->get(),
            'types' => OfferType::query()
                ->whereNull('parent_id')
                ->where('id', '!=', $this->resource->id)
                ->select(['name', 'id', 'slug'])
                ->get()
                ->prepend(['id' => null, 'name' => 'No Parent']),
        ];
    }
}
