<?php

namespace App\Modules\CatalogOffers\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Modules\CatalogOffers\Http\Requests\StoreCatalogOfferRequest;
use App\Modules\CatalogOffers\Http\Requests\UpdateCatalogOfferRequest;
use App\Modules\CatalogOffers\Http\Resources\CatalogOfferList;
use App\Modules\CatalogOffers\Http\Resources\CatalogOfferView;
use Mtc\ContentManager\Facades\Media;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\CatalogOffer;

class CatalogOfferController extends Controller
{
    public function index(Request $request): CatalogOfferList
    {
        $query = CatalogOffer::query();

        if ($request->filled('type')) {
            $query->ofType($request->input('type'));
        }

        return new CatalogOfferList($query->paginate());
    }

    public function show(CatalogOffer $catalogOffer): CatalogOfferView
    {
        return new CatalogOfferView($catalogOffer);
    }

    public function store(StoreCatalogOfferRequest $request): CatalogOfferView
    {
        $catalogOffer = CatalogOffer::query()
            ->create($request->input());
        return new CatalogOfferView($catalogOffer);
    }

    public function update(UpdateCatalogOfferRequest $request, CatalogOffer $catalogOffer): CatalogOfferView
    {
        $catalogOffer->update($request->input());
        Media::setUsesForModel(
            $request->input('media', []),
            $catalogOffer,
            [
                'primary' =>  true,
                'allowed_sizes' => config('automotive.catalog_offers_sizes', [])
            ],
        );

        $rules = collect($request->input('rules', []));

        // Remove rules not in list
        $catalogOffer->rules()
            ->whereNotIn('id', $rules->pluck('id'))
            ->delete();

        // Add/Update rules - serialize array values to JSON
        $rules->each(function ($rule) use ($catalogOffer) {
            if (isset($rule['value']) && is_array($rule['value'])) {
                $rule['value'] = json_encode($rule['value']);
            }
            $catalogOffer->rules()->updateOrCreate(['id' => $rule['id']], $rule);
        });

        return new CatalogOfferView($catalogOffer);
    }

    public function destroy(Request $request, CatalogOffer $catalogOffer): CatalogOfferList
    {
        $catalogOffer->delete();
        return $this->index($request);
    }
}
