<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FuseSyncReservationSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Fuse CRM',
                'name' => 'Sync Reservation Enabled',
                'config_key' => 'fuse-crm-sync-reservation-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Enable calling the Fuse Sync Reservation API when a vehicle is reserved'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Fuse CRM',
                'name' => 'Sync Reservation API Key',
                'config_key' => 'fuse-crm-sync-reservation-api-key',
                'type' => 'secret',
                'value' => '',
                'description' => 'API key for the Fuse Sync Reservation API (X-Fuse-Apikey header)'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Fuse CRM',
                'name' => 'Sync Reservation API Domain',
                'config_key' => 'fuse-crm-sync-reservation-domain',
                'type' => 'string',
                'value' => '',
                'description' => 'Base URL for Fuse Sync Reservation API. Include the protocol (e.g https://example.com or https://account.example.com), no trailing slash at the end'
            ],
        ];
    }
}
