<?php

namespace App\Listeners;

use App\AIContentRepository;
use App\Events\NewVehicleImported;
use App\Facades\Settings;
use App\Jobs\FetchAIDescription;
use Illuminate\Foundation\Bus\DispatchesJobs;

class CreateVehicleAiDescriptionOnNewVehicleImport
{
    use DispatchesJobs;

    /**
     * Create the event listener.
     */
    public function __construct(
        protected AIContentRepository $AIContentRepository
    ) {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(NewVehicleImported $event): void
    {
        if (
            $this->AIContentRepository->hasEnabledIntegration()
            && $this->AIContentRepository->canGenerateDescriptionOnImport()
        ) {
            $this->dispatch(new FetchAIDescription($event->vehicle));
        }
    }
}
