<?php

namespace App\Modules\Lookup\Config;

use App\Facades\Settings;

class AutoTraderConnect extends \Mtc\VehicleValuation\Config\AutoTraderConfig
{
    public function enabled(): bool
    {
        return Settings::get('valuation-auto-trader-enabled') ?? false;
    }

    public function merchantId(): string
    {
        return Settings::get('auto-trader-advertiser-id') ?? '';
    }

    public function apiKey(): string
    {
        return config('lookup.drivers.at-connect.api_key');
    }

    public function apiSecret(): string
    {
        return config('lookup.drivers.at-connect.api_secret');
    }
}
