<?php

namespace App\Modules\Valuation\Http\Resources;

use App\Traits\FormatAsCurrency;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\ValuationAdjustment;

class ValuationAdjustmentList extends JsonResource
{
    use FormatAsCurrency;

    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->through(fn(ValuationAdjustment $adjustment) => $this->mapAdjustment($adjustment));
        return parent::toArray($request);
    }

    private function mapAdjustment(ValuationAdjustment $adjustment)
    {
        $amount = $adjustment->adjustment_type === 'percent'
            ? $adjustment->adjustment_amount . '%'
            : $this->asCurrency($adjustment->adjustment_amount, tenant()->currency);
        $adjustment->name = $adjustment->is_increase
            ? __('valuations.adjustment_increase', ['amount' => $amount])
            : __('valuations.adjustment_decrease', ['amount' => $amount]);
        $adjustment->description = '';
        return $adjustment;
    }
}
