<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AlternateLogoSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Alternate Site Logo',
                'config_key' => 'site-alternate-logo',
                'type' => 'image',
                'validation_rules' => 'required',
                'choices' => ".svg,.png",
                'description' => 'Second logo of your website. Used where monochrome or inverted colours needed',
                'order' => 2,
            ],
        ];
    }
}
