<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\ContentManager\Http\Resources\MediaEntryResource;

class SeoDefaultResource extends JsonResource
{
    public static $wrap = null;

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = parent::toArray($request);
        $data['supported_tags'] = __("seo.default_tags.{$this->resource->section}");

        if ($this->resource->ogImage) {
            $data['media_uses'] = [new MediaEntryResource($this->resource->ogImage)];
            $data['ogImage'] = [$this->resource->ogImage->media_id];
        }

        $data['created_at'] = $this->resource->created_at?->format('d/m/Y H:i');
        $data['updated_at'] = $this->resource->updated_at?->format('d/m/Y H:i');

        return $data;
    }
}
