<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SeoRedirectResource extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = parent::toArray($request);
        $data['created_at'] = $this->resource->created_at?->format('d/m/Y H:i');
        $data['updated_at'] = $this->resource->updated_at?->format('d/m/Y H:i');
        return $data;
    }
}
