<?php

namespace App\VehicleSpec\Config;

use App\Facades\Settings;

class MotorCheckConfig
{
    public function enabled(): bool
    {
        return Settings::get('vehicle-spec-providers-motor-check-enabled') ?? false;
    }

    public function clientId(): string
    {
        return Settings::get('vehicle-spec-providers-motor-check-client_id');
    }

    public function clientSecret(): string
    {
        return Settings::get('vehicle-spec-providers-motor-check-client_secret');
    }

    public function country(): string
    {
        return strtolower(Settings::get('app-details-country') ?? 'gb');
    }
}
