<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PhoneNumberFormatUpdate extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Phone Number format',
                'config_key' => 'app-phone-number-format',
                'type' => 'string',
                'choices' => [
                    ['value' => '3-3-4', 'name' => 'XXX-YYY-ZZZZ (3-3-4)'],
                    ['value' => '4-3-3', 'name' => 'XXXX-YYY-ZZZ (4-3-3)'],
                    ['value' => '5-3-3', 'name' => 'XXXXX-YYY-ZZZ (5-3-3)'],
                    ['value' => '5-6', 'name' => 'XXXXX-YYYYYY (5-6)'],
                ],
                'validation_rules' => 'required',
                'description' => 'Way of displaying phone numbers',
            ],
        ];
    }
}
