<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class SilverBulletSourceSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Marketing campaign source to pass to eCommerce',
                'config_key' => 'sales-silver-bullet-campaign-source',
                'type' => 'string',
                'value' => '',
                'order' => 13,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Vehicle page URL path',
                'config_key' => 'vehicles-url-path',
                'type' => 'string',
                'value' => '/vehicle/{{SLUG}}',
                'order' => 1,
                'min_tier' => 'enterprise',
                'description' => 'path - e.g. /vehicle/{{SLUG}} or /car-details/{{MAKE}}/{{MODEL}}/{{SLUG}} . '
                    . 'Supports MAKE MODEL and SLUG placeholders. Used for URL generating in API, '
                    . 'must match the implementation in theme!',
            ],
        ];
    }
}
