<?php

namespace Tests\Unit;

use App\Rules\ValidVehicleRegistrationNumber;
use Database\Seeders\Global\CountrySeeder;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class VehicleRegistrationNumberRuleTest extends TestCase
{
    use RefreshDatabase;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function test_example()
    {
        $this->seed(CountrySeeder::class);

        $this->assertTrue((new ValidVehicleRegistrationNumber())->passes('registration_number', 'AB59 DAC'));
        $this->assertTrue((new ValidVehicleRegistrationNumber())->passes('registration_number', 'AB59DAC'));
        $this->assertTrue((new ValidVehicleRegistrationNumber())->passes('registration_number', 'WE91 SEB'));
        $this->assertTrue((new ValidVehicleRegistrationNumber())->passes('registration_number', 'VE09DEL'));

        $this->assertFalse((new ValidVehicleRegistrationNumber())->passes('registration_number', '1DEL231'));
        $this->assertFalse((new ValidVehicleRegistrationNumber())->passes('registration_number', 'LV-1111'));
        $this->assertFalse((new ValidVehicleRegistrationNumber())->passes('registration_number', 'LV1111'));
        $this->assertFalse((new ValidVehicleRegistrationNumber())->passes('registration_number', 'DE23AA'));
        $this->assertFalse((new ValidVehicleRegistrationNumber())->passes('registration_number', '23AAD'));

        $this->assertTrue((new ValidVehicleRegistrationNumber(true))->passes('registration_number', 'NINJA'));
        $this->assertTrue((new ValidVehicleRegistrationNumber(true))->passes('registration_number', '007'));
        $this->assertTrue((new ValidVehicleRegistrationNumber(true))->passes('registration_number', 'VICTORY'));
        $this->assertTrue((new ValidVehicleRegistrationNumber(true))->passes('registration_number', 'LAMBO'));

        $this->assertTrue((new ValidVehicleRegistrationNumber(false, true))->passes('registration_number', null));
        $this->assertTrue((new ValidVehicleRegistrationNumber(false, true))->passes('registration_number', ''));

        $this->assertTrue((new ValidVehicleRegistrationNumber(false, true))->passes('registration_number', 'AB59 DAC'));
        $this->assertFalse(
            (new ValidVehicleRegistrationNumber(false, true))->passes('registration_number', 'INVALID123')
        );
        $this->assertTrue(
            (new ValidVehicleRegistrationNumber(true, true))->passes('registration_number', 'HELLO WORLD')
        );
    }
}
