<?php

namespace App\Rules;

use App\Facades\Settings;
use Illuminate\Contracts\Validation\Rule;
use Mtc\MercuryDataModels\Country;
use Mtc\MercuryDataModels\Vehicle;

class VehicleExistsByIdentifier implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value): bool
    {
        $country = Settings::get('app-details-country') ?? config('app.default_country');
        return Vehicle::query()
            ->where('registration_number', Country::normalizeNumberPlate($country, $value))
            ->orWhere('vin', $value)
            ->exists();
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Vehicle not found in database.';
    }
}
