<?php

namespace App;

use Mtc\ContentManager\Contracts\PageModel;
use Mtc\MercuryDataModels\Contracts\ModelWithUrlPath;
use Mtc\MercuryDataModels\SeoData;

trait SavesSeoData
{
    /**
     * Save Seo Data for page
     *
     * @param PageModel $page
     * @param array $input
     * @param string|null $oldPath Previous path if slug changed, to migrate seo_data entry
     * @return void
     */
    protected function saveSeo(ModelWithUrlPath $page, array $input, ?string $oldPath = null): void
    {
        $newPath = $page->urlPath();

        // If path changed, update the existing seo_data entry's path
        if ($oldPath && $oldPath !== $newPath) {
            SeoData::query()
                ->where('path', $oldPath)
                ->update(['path' => $newPath]);
        }

        $hasFields = collect($input)
            ->filter()
            ->hasAny(['title', 'description', 'keywords', 'heading', 'jsonSchema', 'canonical', 'index_follow']);

        if ($hasFields) {
            SeoData::query()
                ->updateOrCreate([
                    'path' => $newPath,
                ], [
                    'title' => $input['title'] ?? null,
                    'description' => $input['description'] ?? null,
                    'keywords' => $input['keywords'] ?? null,
                    'heading' => $input['heading'] ?? null,
                    'canonical' => $input['canonical'] ?? null,
                    'index_follow' => $input['index_follow'] ?? null,
                    'json_schema' => $input['jsonSchema'] ?? null,
                ]);
        } else {
            SeoData::query()
                ->where('path', $newPath)
                ->delete();
        }
    }
}
