<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MotorCheckLookupSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'MotorCheck',
                'name' => 'Enabled',
                'config_key' => 'lookup-motor-check-enabled',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'MotorCheck',
                'name' => 'MotorCheck Client Id',
                'config_key' => 'lookup-motor-check-client_id',
                'type' => 'string',
                'min_tier' => 'pro',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.lookup-motor-check-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'MotorCheck',
                'name' => 'MotorCheck Client Secret',
                'config_key' => 'lookup-motor-check-client_secret',
                'type' => 'secret',
                'min_tier' => 'pro',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.lookup-motor-check-enabled,true"
                ]
            ],
        ];
    }
}
