<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PostcodeMileageFilterSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Postcode mileage options',
                'config_key' => 'automotive-vehicle-filters-postcode-mileage',
                'type' => 'text',
                'superadmin' => true,
                'value' => '1000:National,1:Within 1 mile,10:Within 10 miles,20:Within 20 miles,30:Within 30 miles,
                40:Within 40 miles,50:Within 50 miles,60:Within 60 miles,100:Within 100 miles,200:Within 200 miles',
                'description' => 'value:name,value:name'
            ],
        ];
    }
}
