<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\MercuryDataModels\Tenant;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class TenantDailyMetric extends Model
{
    use CentralConnection;

    protected $fillable = [
        'tenant_id',
        'date',
        'enquiries_count',
        'service_bookings_count',
        'reservations_count',
        'valuations_count',
        'vehicles_added',
        'vehicles_exited',
        'visitors',
        'enquiry_conversion_rate',
        'booking_conversion_rate',
        'reservation_conversion_rate',
        'revenue',
    ];

    protected $casts = [
        'date' => 'date',
        'enquiries_count' => 'integer',
        'service_bookings_count' => 'integer',
        'reservations_count' => 'integer',
        'valuations_count' => 'integer',
        'vehicles_added' => 'integer',
        'vehicles_exited' => 'integer',
        'visitors' => 'integer',
        'enquiry_conversion_rate' => 'decimal:2',
        'booking_conversion_rate' => 'decimal:2',
        'reservation_conversion_rate' => 'decimal:2',
        'revenue' => 'decimal:2',
    ];

    /**
     * Get the tenant that owns this metric.
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class);
    }
}
