<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OpenAIDescriptionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AI',
                'group' => 'Open AI',
                'name' => 'Generate Description When Vehicle Imported',
                'config_key' => 'open-ai-generate-description-on-vehicle-imported',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
                'description' => '',
            ],
        ];
    }
}
