<?php

namespace App\Http\Controllers;

use App\ColourMapRepository;
use App\Http\Requests\SetColourMapRequest;
use App\Http\Resources\ColourMapResource;
use App\Jobs\AutomaticallyMapColours;

class ColourMapController extends Controller
{
    public function index(): ColourMapResource
    {
        return new ColourMapResource([]);
    }

    public function update(SetColourMapRequest $request, ColourMapRepository $repository)
    {
        $repository->update($request->input('colours', []));
        return new ColourMapResource([]);
    }

    public function autoMap(): ColourMapResource
    {
        AutomaticallyMapColours::dispatchSync();
        return new ColourMapResource([]);
    }
}
