<?php

namespace App\Listeners;

use App\Events\NewVehicleImported;
use App\Events\VehicleUpdatedFromImport;
use App\VehicleStockSyncLogRepository;
use Mtc\MercuryDataModels\VehicleStockSyncLog;

class StoreVehicleImportStockSyncLog
{
    public function __construct(private VehicleStockSyncLogRepository $repository)
    {
        //
    }

    public function handle(VehicleUpdatedFromImport|NewVehicleImported $event)
    {
        if (!$event->provider || !$this->repository->enabled()) {
            return;
        }

        if (tenant()->type === 'listing') {
            return;
        }

        $this->repository->store(
            $event->vehicle,
            $event->payload,
            $event->provider,
            VehicleStockSyncLog::ACTION_IMPORT
        );
    }
}
