<?php

namespace App\Modules\Leasing\Jobs;

use App\LeaseVehicleRepository;
use Mtc\MercuryDataModels\KeyloopLeaseVehicleVariant;

class ImportVariantsJob extends BaseImportJob
{
    protected function importItem(array $item)
    {
        $variant = KeyloopLeaseVehicleVariant::query()->firstOrNew(
            [
                'external_variant_id' => $item['external_variant_id'],
            ],
        );

        $variant->fill([
            'was_recently_synced' => true,
            'make_id' => $item['make_id'],
            'model_id' => $item['model_id'],
            'transmission_id' => $item['transmission_id'],
            'fuel_type_id' => $item['fuel_type_id'],
            'body_style_id' => $item['body_style_id'],
            'name' => $item['name'],
            'is_current_variant' => $item['is_current_variant'],
            'type' => $item['type'],
            'engine_size_cc' => $item['engine_size_cc'],
            'brake_horsepower' => $item['brake_horsepower'],
            'co2' => $item['co2'],
            'door_count' => $item['door_count'],
            'seats' => $item['seats'],
            'road_fund_licence' => $item['road_fund_licence'],
            'finance_recently_updated' => false,
        ]);

        $variant->slug = (new LeaseVehicleRepository())->buildSlug($variant);
        $variant->save();
    }
}
