<?php

namespace Database\Seeders\Tenant;

use Illuminate\Database\Seeder;
use Mtc\Crm\Models\EnquiryType;
use Mtc\Crm\Models\Form;

class GeneralEnquirySeeder extends Seeder
{
    public function run()
    {
        $this->createForm('General Enquiry', 'General Contact Enquiry');
    }

    protected function createForm(string $name, string $type, array $additionalFields = [])
    {
        /** @var Form $form */
        $form = Form::query()->create([
            'name' => $name,
            'type_id' => EnquiryType::query()->where('name', $type)->first()->id ?? 0,
            'is_active' => 1,
            'initial_status_id' => 1,
            'notify_customer_on_received_enquiry' => 1,
            'customer_notification_subject' => 'We have received your enquiry',
            'customer_notification_content' => 'We will reply to your query in a timely manner.',
            'data' => ['multistep' => false],
        ]);

        $section = $form->sections()->create([
            'name' => 'Section',
            'segments' => ['Header', 'Fields', 'Actions'],
        ]);

        $this->createQuestion($form, [
            'segment' => 'Header',
            'form_section_id' => $section->id,
            'name' => $name,
            'type' => 'message',
        ]);

        $fields = array_merge([
            [
                'name' => 'First Name',
                'type' => 'text_field',
                'is_enquiry_subject' => 1,
                'validation' => ['required'],
            ],
            [
                'name' => 'Last Name',
                'type' => 'text_field',
                'is_enquiry_subject' => 1,
                'validation' => ['required'],
            ],
            [
                'name' => 'Email Address',
                'type' => 'email_field',
                'is_customers_email' => 1,
                'validation' => ['required', 'email'],
            ],
            [
                'name' => 'Phone Number',
                'type' => 'text_field',
                'validation' => ['required'],
            ],
            [
                'name' => 'Message',
                'type' => 'text_area',
                'validation' => ['required'],
            ],
            [
                'segment' => 'Actions',
                'name' => 'Submit',
                'type' => 'submit_button',
            ],
        ], $additionalFields);

        $marketing_preferences = [
            [
                'name' => 'Please confirm that you have read and agree to our <a href="/terms-and-conditions" target="_blank">Terms & Conditions</a> and <a href="/privacy-policy" target="_blank">Privacy Policy</a>.',
                'type' => 'yes_/_no',
                'validation' => ['required'],
                'data' => [
                    'component' => 'Boolean',
                    'componentName' => 'Boolean',
                    'dealer-web-lms-field' => 'include_in_details_content',
                ]
            ],
            [
                'name' => 'Which communication methods are you happy for us to contact you through?',
                'type' => 'checkbox_list',
                'data' => [
                    'dealer-web-lms-field' => 'marketing_preference',
                    'component' => 'CheckboxList',
                    'componentName' => 'CheckboxList',
                    'meta' => [
                        'content' => 'Phone:Phone
    Email:Email
    SMS:SMS
    Post:Post',
                        'options' => [
                            'items' => [
                                ['name' => 'Phone', 'value' => 'Phone'],
                                ['name' => 'Email', 'value' => 'Email'],
                                ['name' => 'SMS', 'value' => 'SMS'],
                                ['name' => 'Post', 'value' => 'Post'],
                            ]
                        ]
                    ]
                ]
            ]
        ];

        foreach ($fields as $field) {
            $this->createQuestion($form, array_merge(['form_section_id' => $section->id], $field));
        }

        foreach ($marketing_preferences as $field) {
            $this->createQuestion($form, array_merge(['form_section_id' => $section->id], $field));
        }
    }

    protected function createQuestion(Form $form, array $field)
    {
        $form->questions()->create([
            'segment' => $field['segment'] ?? 'Fields',
            'form_section_id' => $field['form_section_id'],
            'name' => $field['name'] ?? null,
            'type' => $field['type'] ?? null,
            'data' => $field['data'] ?? null,
            'is_customers_email' => $field['is_customers_email'] ?? 0,
            'is_enquiry_subject' => $field['is_enquiry_subject'] ?? 0,
            'validation' => $field['validation'] ?? null,
            'placeholder' => $field['placeholder'] ?? null,
            'answer_options' => $field['answer_options'] ?? null,
            'settings' => $field['settings'] ?? null,
            'is_active' => 1,
        ]);
    }
}
